var delayError = 2000;
var delayRepeat = 3000;
var responseError = false;
var heater = false;
// var heaterError = false;//TODO: avec vérification com I2C
var msgComError = "Pas de réception";
var msgMeasures = "Mesures en cours";
// var msgMeasuresError = ""; //TODO: avec vérification com I2C
var msgHeaterOn = ", dernière commande chauffage acquittée = on";
var msgHeaterOff = ", dernière commande chauffage acquittée = off";
// var msgHeaterError = ", erreur chauffage"; // TODO: avec mesure courant Chauffage

$('#messages').empty();

$('input').click(function () {
    var valeur = '0';
    if ($(this).attr('value') == 'on') {
        valeur = '1';
    }
    else if ($(this).attr('value') == 'off') {
        valeur = '0';
    }

    $.ajax({
        url: 'scripts/setHeater.php',
        type: 'get',
        data: $(this).attr('name') + '=' + valeur,
        success: function (data) {
            if (data == 1) {
                heater = true;
                displayMessage();
            } else if (data == 0) {
                heater = false;
                displayMessage();
            } else {
                //heaterError = true;
                //TODO: avec mesure courant Chauffage
            }
        },
        timeout: delayError,
        error: function () {
            responseError = true;
            displayMessage();
        }
    });
    return false;
});

function loadMeasures() {
    var temperature = '', humidite = '';

    $.ajax({
        url: 'scripts/get_temp_hum.php',
        type: 'get',
        dataType: 'json',
        success: function (data) {
            $.each(data, function (entryIndex, entry) {
                temperature = entry.temp;
                humidite = entry.hum;
            });
            if (responseError) { // Utilisé lors d'une reconnexion
                $('#messages').empty();
                responseError = false;
            }
            $("#temperature").html(temperature);
            $("#humidite").html(humidite);
            displayMessage();
        },
        timeout: delayError,
        error: function () {
            responseError = true;
            displayMessage();
        }
    });
};

function displayMessage() {
    let state = responseError ? 2 : 0;
    state = heater ? state + 1 : state;

    switch (state) {
        case 0:
            $('#messages').html(msgMeasures + msgHeaterOff).css('font-size', 'small');
            break;
        case 1:
            $('#messages').html(msgMeasures + msgHeaterOn).css('font-size', 'small');
            break;
        case 2:
            $('#messages').html(msgComError + msgHeaterOff).css('font-size', 'small');
            $("#temperature").html('NC');
            $("#humidite").html('NC');
            break;
        case 3:
            $('#messages').html(msgComError + msgHeaterOn).css('font-size', 'small');
            $("#temperature").html('NC');
            $("#humidite").html('NC');
            break;
        default:
            $('#messages').html("Erreur affichage").css('font-size', 'small');
            break;
    }
    return;
}

loadMeasures(); // premiere execution

setInterval(function () {
    loadMeasures()
}, delayRepeat);